/*
 * Decompiled with CFR 0.152.
 */
package graph.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import shared.Table;

public class ExcelReader {
    String filename;

    public ExcelReader(String filename) {
        this.filename = filename;
    }

    public void read(Table table) {
        this.read(table, this.filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Table table, String filename) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(filename));
            XSSFSheet sheet = new XSSFWorkbook((InputStream)fis).getSheetAt(0);
            Iterator rowIt = sheet.iterator();
            int columnsCount = this.getColumnsCount(sheet.iterator());
            boolean headerRow = true;
            int rowsCount = 0;
            while (rowIt.hasNext()) {
                Row row = (Row)rowIt.next();
                if (this.rowIsEmpty(row, columnsCount)) {
                    break;
                }
                for (int i = 0; i < columnsCount; ++i) {
                    String cellContent;
                    Cell cell = row.getCell(i, Row.MissingCellPolicy.RETURN_NULL_AND_BLANK);
                    if (cell != null) {
                        cell.setCellType(CellType.STRING);
                    }
                    String string = cellContent = cell == null ? "" : cell.toString();
                    if (headerRow) {
                        if (i == 0) {
                            table.setName(cellContent);
                            continue;
                        }
                        table.addAttribute(cellContent);
                        continue;
                    }
                    if (i == 0) {
                        table.addItem(cellContent);
                        continue;
                    }
                    if (cellContent.equals("x")) {
                        table.addValue(Float.valueOf(1.0f), rowsCount - 1);
                        continue;
                    }
                    if (cellContent.isEmpty()) {
                        table.addValue(Float.valueOf(0.0f), rowsCount - 1);
                        continue;
                    }
                    table.addValue(Float.valueOf(Float.parseFloat(cellContent)), rowsCount - 1);
                }
                ++rowsCount;
                headerRow = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private boolean rowIsEmpty(Row row, int cols) {
        if (row == null) {
            return true;
        }
        if (row.getLastCellNum() <= 0) {
            return true;
        }
        for (int i = 0; i < cols; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null || cell.getCellType() == CellType.BLANK) continue;
            return false;
        }
        return true;
    }

    private int getColumnsCount(Iterator<Row> rowIt) {
        int result = 1;
        try {
            if (rowIt.hasNext()) {
                Cell cell;
                Row row = rowIt.next();
                Iterator cellIterator = row.cellIterator();
                cellIterator.next();
                while (cellIterator.hasNext() && !(cell = (Cell)cellIterator.next()).getStringCellValue().isEmpty()) {
                    ++result;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

